import numpy as np
import tkinter.filedialog as fd
import scipy.optimize as opt

fname = fd.askopenfilename()
t, r = np.loadtxt(fname, delimiter=',', usecols=(0,1), 
                  unpack=True)

x = np.log(r*1000)
y = 1/(t+273.15)
z = t + 273.15

def linearized_sh(x, a, b, d):
    return a + b*x + d*x**3

def nonlinear_sh(x, a, b, d):
    return 1/(a + b*x + d*x**3)

def polynomial(x, a, b, c, d):
    return a + b*x + c*x**2 + d*x**3


p0 = 1.e-3, 1.e-4, 1e-7
popt, pcov = opt.curve_fit(linearized_sh, x, y, p0)


#p0 = 1.e-3, 1.e-4, 1e-7
#popt, pcov = opt.curve_fit(nonlinear_sh, x, z, p0)


#p0 = 1.e-3, 1.e-4, 1e-7, 1e-7
#popt, pcov = opt.curve_fit(polynomial, x, y, p0)


print(popt)
print(pcov)

